<?php

namespace Sits\Setting\Livewire\Plugin;

use Livewire\Component;
use Sits\Base\Services\PluginGenerator;

class PluginComponent extends Component
{
    public string $name = '';
    public ?string $successMessage = null;
    public ?string $errorMessage = null;

    protected function rules()
    {
        return [
            'name' => [
                'required',
                'string',
                'regex:/^[A-Z][a-zA-Z]{2,}$/'
            ],
        ];
    }
    protected function messages()
    {
        return [
            'name.regex' => 'The name must start with an uppercase letter and contain only letters (no numbers), with at least 3 characters.',
        ];
    }

    public function create_plugin(PluginGenerator $generator)
    {
        $this->reset(['successMessage', 'errorMessage']);

        $validated = $this->validate();

        try {
            $message = $generator->generate($validated['name']);

            $this->successMessage = $message ?? 'Plugin generated successfully!';
            $this->reset('name');

            // Dispatch success toast
            $this->dispatch('SitsToast', [
                'status'  => true,
                'message' => $this->successMessage,
            ]);
        } catch (\Exception $e) {
            $this->errorMessage = "Error: " . $e->getMessage();

            // Dispatch error toast
            $this->dispatch('SitsToast', [
                'status'  => false,
                'message' => $this->errorMessage,
            ]);
        }
    }

    public function render()
    {
        return view('sits/setting::livewire.plugin.plugin-component');
    }
}
