<?php

namespace Sits\Base\Services;

use Illuminate\Support\Facades\File;

class PluginGenerator
{
    protected $stubBasePath = 'sits/core/base/resources/stubs/plugin/';

    public function generate($pluginName)
    {
        $pluginNameLower = strtolower($pluginName);
        $basePath = base_path("sits/plugins/$pluginNameLower");

        if (File::exists($basePath)) {
            throw new \Exception("Plugin [$pluginName] already exists!");
        }

        $folders = [
            "routes",
            "resources/views",
            "database/migrations",
            "src/Http/Controllers",
            "src/Models",
            "src/Providers",
            "helper",
        ];

        foreach ($folders as $folder) {
            File::makeDirectory("$basePath/$folder", 0755, true, true);
        }

        // Publish stub files
        $this->publishStub('web.php.stub', "$basePath/routes/web.php", $pluginName, $pluginNameLower);
        $this->publishStub('index.blade.php.stub', "$basePath/resources/views/index.blade.php", $pluginName, $pluginNameLower);
        $this->publishStub('details.blade.php.stub', "$basePath/resources/views/details.blade.php", $pluginName, $pluginNameLower);
        $this->publishStub('single.blade.php.stub', "$basePath/resources/views/single.blade.php", $pluginName, $pluginNameLower);
        $this->publishStub('table-details.blade.php.stub', "$basePath/resources/views/table-details.blade.php", $pluginName, $pluginNameLower);
        $this->publishStub('plugin.json.stub', "$basePath/plugin.json", $pluginName, $pluginNameLower);
        $this->publishStub('Model.php.stub', "$basePath/src/Models/{$pluginName}.php", $pluginName, $pluginNameLower);
        $this->publishStub('table.php.stub', "$basePath/database/migrations/0001_01_01_000000_create_{$pluginNameLower}s_table.php", $pluginName, $pluginNameLower);
        $this->publishStub('controller.php.stub', "$basePath/src/Http/Controllers/{$pluginName}Controller.php", $pluginName, $pluginNameLower);
        $this->publishStub('ServiceProvider.php.stub', "$basePath/src/Providers/{$pluginName}ServiceProvider.php", $pluginName, $pluginNameLower);

        return "Plugin [$pluginName] created successfully at sits/plugins/$pluginName";
    }

    protected function publishStub($stubName, $destination, $pluginName, $pluginNameLower)
    {
        $stubPath = base_path($this->stubBasePath . $stubName);



        if (!File::exists($stubPath)) {
            throw new \Exception("Stub file not found: $stubPath");
        }

        $stub = File::get($stubPath);

        $rendered = str_replace(
            ['{{ pluginName }}', '{{ pluginNameLower }}'],
            [$pluginName, $pluginNameLower],
            $stub
        );

        File::put($destination, $rendered);
    }
}
