@extends('sits/base::master')

@section('content')
    <div class="card">
        <div class="card-body flex flex-col p-6">

            <div class="card-text h-full">
                <div>
                    <ul class="nav nav-tabs flex flex-col md:flex-row flex-wrap list-none border-b pl-0 mb-4" id="tabs-tab"
                        role="tablist">
                        <li class="nav-item" role="presentation">
                            <a href="#tabs-home-withIcon"
                                class="nav-link w-full flex items-center font-medium text-sm font-Inter leading-tight capitalize border-x-0 border-t-0 border-b border-transparent px-4 pb-2 mt-2 hover:border-transparent focus:border-transparent active dark:text-slate-300"
                                id="tabs-home-withIcon-tab" data-bs-toggle="pill" data-bs-target="#tabs-home-withIcon"
                                role="tab" aria-controls="tabs-home-withIcon" aria-selected="true">
                                <iconify-icon class="mr-1" icon="heroicons-outline:home"></iconify-icon>
                                General</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a href="#tabs-email-withIcon"
                                class="nav-link w-full flex items-center font-medium text-sm font-Inter leading-tight capitalize border-x-0 border-t-0 border-b border-transparent px-4 pb-2 mt-2 hover:border-transparent focus:border-transparent dark:text-slate-300"
                                id="tabs-messages-withIcon-tab" data-bs-toggle="pill" data-bs-target="#tabs-email-withIcon"
                                role="tab" aria-controls="tabs-email-withIcon" aria-selected="false">
                                <iconify-icon class="mr-1" icon="heroicons-outline:chat-alt-2"></iconify-icon>
                                SMTP</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a href="#tabs-app-withIcon"
                                class="nav-link w-full flex items-center font-medium text-sm font-Inter leading-tight capitalize border-x-0 border-t-0 border-b border-transparent px-4 pb-2 mt-2 hover:border-transparent focus:border-transparent dark:text-slate-300"
                                id="tabs-messages-withIcon-tab" data-bs-toggle="pill" data-bs-target="#tabs-app-withIcon"
                                role="tab" aria-controls="tabs-app-withIcon" aria-selected="false">
                                <iconify-icon class="mr-1" icon="heroicons-outline:chat-alt-2"></iconify-icon>
                                App</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a href="#tabs-notification-withIcon"
                                class="nav-link w-full flex items-center font-medium text-sm font-Inter leading-tight capitalize border-x-0 border-t-0 border-b border-transparent px-4 pb-2 mt-2 hover:border-transparent focus:border-transparent dark:text-slate-300"
                                id="tabs-messages-withIcon-tab" data-bs-toggle="pill"
                                data-bs-target="#tabs-notification-withIcon" role="tab"
                                aria-controls="tabs-notification-withIcon" aria-selected="false">
                                <iconify-icon class="mr-1" icon="heroicons-outline:chat-alt-2"></iconify-icon>
                                FCM</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a href="#tabs-plugin-withIcon"
                                class="nav-link w-full flex items-center font-medium text-sm font-Inter leading-tight capitalize border-x-0 border-t-0 border-b border-transparent px-4 pb-2 mt-2 hover:border-transparent focus:border-transparent dark:text-slate-300"
                                id="tabs-messages-withIcon-tab" data-bs-toggle="pill" data-bs-target="#tabs-plugin-withIcon"
                                role="tab" aria-controls="tabs-plugin-withIcon" aria-selected="false">
                                <iconify-icon class="mr-1" icon="heroicons-outline:chat-alt-2"></iconify-icon>
                                Plugin</a>
                        </li>

                    </ul>
                    <div class="tab-content" id="tabs-tabContent">
                        <div class="tab-pane fade show active" id="tabs-home-withIcon" role="tabpanel"
                            aria-labelledby="tabs-home-withIcon-tab">

                            @livewire('general-settings')
                        </div>

                        <!-- SMTP Tab -->
                        <div class="tab-pane fade" id="tabs-email-withIcon" role="tabpanel"
                            aria-labelledby="tabs-messages-withIcon-tab">
                            @livewire('smtp-configuration')
                            @livewire('smtp-verification')
                        </div>
                        <!-- End SMTP Tab -->

                        <div class="tab-pane fade" id="tabs-app-withIcon" role="tabpanel"
                            aria-labelledby="tabs-messages-withIcon-tab">
                            <div class="">

                                <!-- App Settings Form -->
                                <div>Coming Soon</div>
                                <div class="bg-white p-6 rounded-lg hidden">
                                    <form action="#" method="POST">
                                        <div class="grid grid-cols-2 gap-4">
                                            <!-- App Link -->
                                            <div>
                                                <label for="app-link" class="block text-sm font-medium text-gray-600">App
                                                    Link</label>
                                                <input type="text" id="app-link" name="app_link"
                                                    class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                                    placeholder="App Link">
                                            </div>

                                            <!-- iOS App Link -->
                                            <div>
                                                <label for="ios-app-link"
                                                    class="block text-sm font-medium text-gray-600">iOS App Link</label>
                                                <input type="text" id="ios-app-link" name="ios_app_link"
                                                    class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                                    placeholder="iOS App Link">
                                            </div>

                                            <!-- App Version (Android) -->
                                            <div>
                                                <label for="android-version"
                                                    class="block text-sm font-medium text-gray-600">App Version
                                                    (Android)</label>
                                                <input type="text" id="android-version" name="android_version"
                                                    class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                                    placeholder="App Version (Android)">
                                            </div>

                                            <!-- App Version (iOS) -->
                                            <div>
                                                <label for="ios-version"
                                                    class="block text-sm font-medium text-gray-600">App Version
                                                    (iOS)</label>
                                                <input type="text" id="ios-version" name="ios_version"
                                                    class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                                    placeholder="App Version (iOS)">
                                            </div>

                                            <!-- Force Update App -->
                                            <div class="flex items-center">
                                                <input id="force-update" name="force_update" type="checkbox"
                                                    class="h-4 w-4 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                                <label for="force-update"
                                                    class="ml-2 text-sm font-medium text-gray-600">Force Update App</label>
                                            </div>

                                            <!-- App Maintenance -->
                                            <div class="flex items-center">
                                                <input id="app-maintenance" name="app_maintenance" type="checkbox"
                                                    class="h-4 w-4 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                                <label for="app-maintenance"
                                                    class="ml-2 text-sm font-medium text-gray-600">App Maintenance</label>
                                            </div>
                                        </div>

                                        <!-- Submit Button -->
                                        <div class="mt-6">
                                            <button type="submit"
                                                class="w-full bg-blue-600 text-white py-2 px-4 rounded-md hover:bg-blue-700 focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50">
                                                Submit
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        </div>
                        <div class="tab-pane fade" id="tabs-notification-withIcon" role="tabpanel"
                            aria-labelledby="tabs-messages-withIcon-tab">
                            Coming Soon
                        </div>
                        <div class="tab-pane fade" id="tabs-plugin-withIcon" role="tabpanel"
                            aria-labelledby="tabs-messages-withIcon-tab">
                            @livewire('plugin-component')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
