<!-- Email Configuration Verification Section -->
<div class="bg-white dark:bg-slate-700 dark:text-white p-6 rounded-lg shadow-md mt-8">
    <h2 class="text-lg font-medium text-gray-700 mb-4 dark:text-white">Create Plugin</h2>

    <div class="space-y-4 mt-5">
        <form wire:submit.prevent="create_plugin">
            <div class="flex items-center space-x-4">
                <input type="text" id="name"
                    class="lg:w-1/4 md:w-1/4 w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                    placeholder="Enter plugin name" wire:model.defer="name" required>

                <button type="submit"
                    class="px-8 py-2 btn inline-flex justify-center btn-outline-light rounded-[25px] bg-primary-900 text-white hover:bg-primary-900 hover:text-white"
                    wire:loading.attr="disabled" wire:loading.class="cursor-not-allowed">
                    <span wire:loading.remove>Submit</span>
                    <span wire:loading>Processing...</span>
                </button>
            </div>
        </form>


        @error('name')
            <span class="text-red-600">{{ $message }}</span>
        @enderror

    </div>
</div>
